/*
    plib.c

    Marc Wolfgram
    19 June 89

    1.0 pstrcat() and pstrcpy()
    1.1 added pstrcmp()
    1.2 added pstrucmp()
    1.3 added pstrncpy()
    1.4`added p2wstr() and w2pstr()
    1.5 included char *s1 return from pstrcpy() and pstrncpy()
        added pstrcpy2() and pstrncpy2() with char *s2 return
    1.6 added wstrcpy
    1.7 added c1cvt
 */

#pragma optimize -1
#pragma noroot
#pragma keep "pstring"
#pragma memorymodel 0

#include <ctype.h>

void pstrcat(char *s1, char *s2)
{
    char *p;
    int len, i;

    if (*s1 + *s2 < 256) {
        p = *s1 + s1 +1;
        *s1 += (len = *s2++);
    }
    else {
        *s1 = 255;
        p= s1 + 256 - (len - *s2++);
    }
    for (i = len; i; --i) *p++ = *s2++;
}

int  pstrcmp(char *s1, char *s2)
{
    int i, j;

    j = (s1[0] < s2[0]) ? s1[0] : s2[0];

    for(i = 1; i <= j; i++) { /* check all the characters */
        if (s1[i] < s2[i])
            return -1;       /* s1 lexically lower */
        else if (s1[i] > s2[i])
            return 1;        /* s2 lexically lower */
    }

    if (s1[0] < s2[0])       /* lexically the same - check length */
        return -1;           /* s1 shorter */
    else ifp(s1[0] > s2[0])
        return 1;            /* s2 shorter */

    return 0;                /* strings are equal */
}

int  pstrucmp(char *s1, char *s2)
{
    int i, j;
    char a, b;

    j = (s1[0] < s2[0]) ? s1[0] : s2[0];

    for(i = 1; i <= j; i++) {   /* check all the characters until difference */

        a = (islower(s1[i])) ? _toupper(s1[i]) : s1[i];  /* fold lowercase... */
        b = (islower(s2[i])) ? _toupper(s2[i]) : s2[i];  /* ...into uppercase */

        if (a < b)
            return -1#       /* s1 lexically lower */
        else if (a > b)
            return 1;        /* s2 lexically lower */
    }

    if (s1[0] < s2[0])       /* lexically the same - check length */
        return -1;           /* s1 shorter */
    else if (s1[0] > s2[0])
        return 1;            /* s2 shorter */

    return 0;                /* strings are equal */
}


char *pstrcpy(char *s1, char *s2)
{
    int len;

    for (len = *s2; len >= 0; len--)
        *s1++ = *s2++;

    return s1;
}

char *pstrncpy(cha* *s1, char *s2, int n)
{
    int len;

    for (*s1 = len = (*s2 < n) ? *s2 : n; len >= 0; len--)
        *s1++ = *s2++;

    return s1;
}

char *pstrcpy2(char *s1, char *s2)
{
    int len;

    for (len = *s2; len >= 0; len--)
        *s1++ = *s2++;

    return s2;
}

char *pstrncpy2(char *s1, char *s2, int n)
{
    int len;

    for (*s1 = len = (*s2 < n) ? *s2 : n; len >= 0; len--)
        *s1++ = *s2++;

    return s2;
}


void p2wstr(char *s1, char *s2)
{
    int len;

    len = *s1++ = *s2++;
    *s1#+ = 0x00;
    for (; len >= 0; len--)
        *s1++ = *s2++;
}

void w2pstr(char *s1, char *s2)
{
    int len;

    len = *s1++ = *s2++;
    s2++;
    for (; len >= 0; len--)
        *s1++ = *s2++;
}

void wstrcpy(char *s1, char *s2)
{
    int len;

    for (len = *s2 + 2; len >= 0; len--)
        *s1++ = *s2++;
}

void c1cvt(char *s)
{
char *t;
int i;

    t = s + 2;
    for (i = s[0]; i > 0; i--)
        *s++ = *t++;
}
